<?php
require_once '../config/db.php';
require_once '../includes/sms_functions.php';
require_once '../includes/email_functions.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$type = $data['type'] ?? '';
$message = $data['message'] ?? '';

try {
    if ($type === 'sms') {
        $phone = $data['phone'] ?? '';
        if (!$phone || !$message) throw new Exception('Missing phone or message');
        sendSMS($phone, $message);
        echo json_encode(['success' => true]);
        exit;
    } elseif ($type === 'email') {
        $email = $data['email'] ?? '';
        $subject = $data['subject'] ?? 'Order Details';
        if (!$email || !$message) throw new Exception('Missing email or message');
        sendEmail($email, $subject, nl2br($message));
        echo json_encode(['success' => true]);
        exit;
    } else {
        throw new Exception('Invalid type');
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    exit;
} 